﻿using System;

namespace VA.PPMS.IWS.TableService.Interface.Entities
{
    public class LeieExclusionEntity
    {
        private enum ParameterType
        {
            Default,
            
            // ReSharper disable InconsistentNaming
            NPI,

            Date
        }

        public const int ColumnSize = 18;
        
        public bool IsValid { get; protected set; }

        public string LastName { get; set; }

        public string FirstName { get; set; }

        public string MidName { get; set; }

        public string BusName { get; set; }

        public string General { get; set; }

        public string Specialty { get; set; }

        public string Upin { get; set; }

        public string Npi { get; set; }

        public string Dob { get; set; }

        public string Address { get; set; }

        public string City { get; set; }

        public string State { get; set; }

        public string Zip { get; set; }

        public string ExclusionType { get; set; }

        public string ExclusionDate { get; set; }

        public string ReinstateDate { get; set; }

        public string WaiverDate { get; set; }

        public string WaiverState { get; set; }

        public LeieExclusionEntity() {}

        public LeieExclusionEntity(string[] parameters)
        {
            IsValid = LoadParameters(parameters);
        }

        private bool LoadParameters(string[] parameters)
        {
            var result = false;

            try
            {
                if (parameters.Length >= 18)
                {
                    LastName = CleanValue(parameters[0]);
                    FirstName = CleanValue(parameters[1]);
                    MidName = CleanValue(parameters[2]);
                    BusName = CleanValue(parameters[3]);
                    General = CleanValue(parameters[4]);
                    Specialty = CleanValue(parameters[5]);
                    Upin = CleanValue(parameters[6]);
                    Npi = CleanValue(parameters[7], ParameterType.NPI);
                    Dob = CleanValue(parameters[8], ParameterType.Date);
                    Address = CleanValue(parameters[9]);
                    City = CleanValue(parameters[10]);
                    State = CleanValue(parameters[11]);
                    Zip = CleanValue(parameters[12]);
                    ExclusionType = CleanValue(parameters[13]);
                    ExclusionDate = CleanValue(parameters[14], ParameterType.Date);
                    ReinstateDate = CleanValue(parameters[15], ParameterType.Date);
                    WaiverDate = CleanValue(parameters[16], ParameterType.Date);
                    WaiverState = CleanValue(parameters[17]);
                    result = true;
                }
            }
            catch (Exception)
            {
                // ignored
            }

            return result;
        }

        private static string CleanValue(string value, ParameterType entityType = ParameterType.Default)
        {

            string checkValue;
            var result = value.Trim();

            switch (entityType)
            {
                case ParameterType.NPI:
                    checkValue = "0000000000";
                    break;
                case ParameterType.Date:
                    checkValue = "00000000";
                    break;
                default:
                    return result;
            }

            return result == checkValue ? null : result;
        }
    }
}